

<?php $__env->startSection('title', 'Doctor Registration'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">Doctor Registration</h1>

    <form method="POST" action="<?php echo e(route('doctor.register')); ?>" enctype="multipart/form-data" class="bg-white rounded-lg shadow p-6">
        <?php echo csrf_field(); ?>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Personal Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                    <input type="text" name="title" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">First Name *</label>
                    <input type="text" name="first_name" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Last Name *</label>
                    <input type="text" name="last_name" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Email *</label>
                    <input type="email" name="email" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone</label>
                    <input type="text" name="phone" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Country</label>
                    <input type="text" name="country" value="Lesotho" class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Professional Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Practice Number *</label>
                    <input type="text" name="practice_number" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Specialization</label>
                    <input type="text" name="specialization" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Qualification</label>
                    <input type="text" name="qualification" class="w-full px-3 py-2 border rounded">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Educational Details</label>
                    <textarea name="educational_details" rows="3" class="w-full px-3 py-2 border rounded"></textarea>
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Account Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Password *</label>
                    <input type="password" name="password" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Confirm Password *</label>
                    <input type="password" name="password_confirmation" required class="w-full px-3 py-2 border rounded">
                </div>
            </div>
        </div>

        <div class="mb-8">
            <h2 class="text-2xl font-bold mb-4">Upload Documents</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Profile Picture</label>
                    <input type="file" name="profile_picture" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Letterhead</label>
                    <input type="file" name="letterhead" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Stamp</label>
                    <input type="file" name="stamp" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Signature</label>
                    <input type="file" name="signature" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <p class="text-xs text-gray-500 mt-1">Optional - Max 2MB</p>
                </div>
            </div>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                Register
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/doctor/register.blade.php ENDPATH**/ ?>